/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.config;

import com.cobblemon.mod.common.CobblemonItems;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.api.file.Versioned;
import org.pokesplash.gts.oldVersion.LangOld;
import org.pokesplash.gts.util.CodecUtils;
import org.pokesplash.gts.util.Utils;

public class Lang
extends Versioned {
    private String title = "\u00a73Gts";
    private String itemListingsTitle = "\u00a73Gts - Items";
    private String pokemonListingsTitle = "\u00a73Gts - Pokemon";
    private String expiredListingsTitle = "\u00a73Gts - Expired";
    private String pokemonTitle = "\u00a73Gts - Pokemon";
    private String itemTitle = "\u00a73Gts - Item";
    private String filteredListingsTitle = "\u00a73Gts - %search%";
    private String historyTitle = "\u00a73Gts - History";
    private String manageTitle = "\u00a73Gts - Manage";
    private String purchaseMessageBuyer = "\u00a72You have bought {listing} from {seller}!";
    private String cancelListing = "\u00a76The {listing} listing has been cancelled!";
    private String returnListingSuccess = "\u00a72You have received the {listing} listing!";
    private String returnListingFail = "\u00a7cCould not receive the {listing} listing.";
    private String maximumListings = "\u00a7cYou can only have a total of {max_listings} listings.";
    private String minimumListingPrice = "\u00a7cYour listing must meet the minimum price of {min_price}";
    private String maximumListingPrice = "\u00a7cYour listing must be below the maximum price of {max_price}";
    private String listingSuccess = "\u00a72Successfully added your {listing} to GTS!";
    private String listingFail = "\u00a7cFailed to add your {listing} to GTS!";
    private String noPokemonInSlot = "\u00a7cCould not find any Pokemon in the given slot!";
    private String noItemInHand = "\u00a7cCould not find an item in your hand!";
    private String bannedItem = "\u00a7c{listing} is banned from GTS!";
    private String bannedPokemon = "\u00a7c{listing} is banned from GTS!";
    private String insufficientItems = "\u00a7cYou don't have enough {listing} in your inventory to list this item!";
    private String itemIdNotFound = "\u00a7cCould not find an item!";
    private String zeroItemAmount = "\u00a7cListing amount can not be zero!";
    private String reloadMessage = "\u00a72Reloaded Configs!";
    private String insufficientFunds = "\u00a7cYou do not have enough money to purchase this listing!";
    private String listingBought = "\u00a72Your {listing} has been bought by {buyer}";
    private String newListingBroadcast = "\u00a7e{seller} \u00a72has just added a \u00a7e{listing} \u00a72to GTS.";
    private String insufficientInventorySpace = "\u00a7cYou do not have enough inventory space to receive this listing.";
    private String onlyOnePokemonInParty = "\u00a7cYou can not list a Pokemon to GTS if you only have less than 2 Pokemon in your party.";
    private String confirmPurchaseButtonLabel = "\u00a72Confirm Purchase";
    private String cancelPurchaseButtonLabel = "\u00a7cCancel Purchase";
    private String removeListingButtonLabel = "\u00a76Remove Listing";
    private String itemListingsButtonLabel = "\u00a79See Item Listings";
    private String pokemonListingsButtonLabel = "\u00a79See Pokemon Listings";
    private String manageListingsButtonLabel = "\u00a7dManage Listings";
    private String nextPageButtonLabel = "\u00a77Next Page";
    private String previousPageButtonLabel = "\u00a77Previous Page";
    private String sortByPriceButtonLabel = "\u00a7eSort By Price";
    private String sortByNewestButtonLabel = "\u00a73Sort By Newest";
    private String sortByPokemonButtonLabel = "\u00a76Sort By Pokemon";
    private String sortByNameButtonLabel = "\u00a76Sort By Name";
    private String receiveListingButtonLabel = "\u00a72Receive Listing";
    private String relistExpiredButtonLabel = "\u00a79Relist Expired";
    private String expiredListingButtonLabel = "\u00a7cExpired Listings";
    private String pokemonBall = "\u00a72Ball: ";
    private JsonElement itemListingsButtonItem;
    private JsonElement pokemonListingsButtonItem;
    private JsonElement manageListingsButtonItem;
    private JsonElement expiredListingsButtonItem;
    private JsonElement nextPageButtonItems;
    private JsonElement previousPageButtonItems;
    private JsonElement fillerItem;
    private JsonElement purchaseButtonItem;
    private JsonElement cancelButtonItem;
    private JsonElement removeListingButtonItem;
    private JsonElement sortByPriceButtonItem;
    private JsonElement sortByNewestButtonItem;
    private JsonElement sortByNameButtonItem;
    private JsonElement relistExpiredButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.RARE_CANDY));
    private String seller = "\u00a79Seller: \u00a7b";
    private String price = "\u00a79Price: \u00a7b";
    private String remainingTime = "\u00a79Time Remaining: \u00a7b";
    private String sold_date = "\u00a79Sold Date: \u00a7b";
    private String buyer = "\u00a79Buyer: \u00a7b";

    public Lang() {
        super("2.6");
        this.itemListingsButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.ASSAULT_VEST));
        this.pokemonListingsButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.POKE_BALL));
        this.manageListingsButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.SACHET));
        this.nextPageButtonItems = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8107));
        this.previousPageButtonItems = CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.POISON_BARB));
        this.fillerItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8736));
        this.purchaseButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8656));
        this.cancelButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8879));
        this.sortByPriceButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8397));
        this.sortByNewestButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8557));
        this.sortByNameButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8788));
        this.expiredListingsButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.LINK_CABLE));
        this.removeListingButtonItem = CodecUtils.encodeItem(new class_1799((class_1935)class_1802.field_8761));
    }

    public String getPurchaseMessageBuyer() {
        return this.purchaseMessageBuyer;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCancelListing() {
        return this.cancelListing;
    }

    public String getReturnListingSuccess() {
        return this.returnListingSuccess;
    }

    public String getReturnListingFail() {
        return this.returnListingFail;
    }

    public String getMaximumListings() {
        return this.maximumListings;
    }

    public String getMinimumListingPrice() {
        return this.minimumListingPrice;
    }

    public String getMaximumListingPrice() {
        return this.maximumListingPrice;
    }

    public String getListingSuccess() {
        return this.listingSuccess;
    }

    public String getListingFail() {
        return this.listingFail;
    }

    public String getNoPokemonInSlot() {
        return this.noPokemonInSlot;
    }

    public String getNoItemInHand() {
        return this.noItemInHand;
    }

    public String getBannedItem() {
        return this.bannedItem;
    }

    public String getInsufficientItems() {
        return this.insufficientItems;
    }

    public String getItemIdNotFound() {
        return this.itemIdNotFound;
    }

    public String getZeroItemAmount() {
        return this.zeroItemAmount;
    }

    public String getReloadMessage() {
        return this.reloadMessage;
    }

    public String getInsufficientFunds() {
        return this.insufficientFunds;
    }

    public String getListingBought() {
        return this.listingBought;
    }

    public class_1799 getItemListingsButtonItem() {
        return CodecUtils.decodeItem(this.itemListingsButtonItem);
    }

    public class_1799 getPokemonListingsButtonItem() {
        return CodecUtils.decodeItem(this.pokemonListingsButtonItem);
    }

    public class_1799 getManageListingsButtonItem() {
        return CodecUtils.decodeItem(this.manageListingsButtonItem);
    }

    public class_1799 getNextPageButtonItems() {
        return CodecUtils.decodeItem(this.nextPageButtonItems);
    }

    public class_1799 getPreviousPageButtonItems() {
        return CodecUtils.decodeItem(this.previousPageButtonItems);
    }

    public class_1799 getFillerItem() {
        return CodecUtils.decodeItem(this.fillerItem);
    }

    public class_1799 getPurchaseButtonItem() {
        return CodecUtils.decodeItem(this.purchaseButtonItem);
    }

    public class_1799 getCancelButtonItem() {
        return CodecUtils.decodeItem(this.cancelButtonItem);
    }

    public class_1799 getSortByPriceButtonItem() {
        return CodecUtils.decodeItem(this.sortByPriceButtonItem);
    }

    public class_1799 getSortByNewestButtonItem() {
        return CodecUtils.decodeItem(this.sortByNewestButtonItem);
    }

    public class_1799 getSortByNameButtonItem() {
        return CodecUtils.decodeItem(this.sortByNameButtonItem);
    }

    public class_1799 getExpiredListingsButtonItem() {
        return CodecUtils.decodeItem(this.expiredListingsButtonItem);
    }

    public class_1799 getRemoveListingButtonItem() {
        return CodecUtils.decodeItem(this.removeListingButtonItem);
    }

    public class_1799 getRelistExpiredButtonItem() {
        return CodecUtils.decodeItem(this.relistExpiredButtonItem);
    }

    public String getNewListingBroadcast() {
        return this.newListingBroadcast;
    }

    public String getInsufficientInventorySpace() {
        return this.insufficientInventorySpace;
    }

    public String getSeller() {
        return this.seller;
    }

    public String getPrice() {
        return this.price;
    }

    public String getRemainingTime() {
        return this.remainingTime;
    }

    public String getConfirmPurchaseButtonLabel() {
        return this.confirmPurchaseButtonLabel;
    }

    public String getCancelPurchaseButtonLabel() {
        return this.cancelPurchaseButtonLabel;
    }

    public String getRemoveListingButtonLabel() {
        return this.removeListingButtonLabel;
    }

    public String getItemListingsButtonLabel() {
        return this.itemListingsButtonLabel;
    }

    public String getPokemonListingsButtonLabel() {
        return this.pokemonListingsButtonLabel;
    }

    public String getManageListingsButtonLabel() {
        return this.manageListingsButtonLabel;
    }

    public String getNextPageButtonLabel() {
        return this.nextPageButtonLabel;
    }

    public String getPreviousPageButtonLabel() {
        return this.previousPageButtonLabel;
    }

    public String getSortByPriceButtonLabel() {
        return this.sortByPriceButtonLabel;
    }

    public String getSortByNewestButtonLabel() {
        return this.sortByNewestButtonLabel;
    }

    public String getSortByPokemonButtonLabel() {
        return this.sortByPokemonButtonLabel;
    }

    public String getSortByNameButtonLabel() {
        return this.sortByNameButtonLabel;
    }

    public String getReceiveListingButtonLabel() {
        return this.receiveListingButtonLabel;
    }

    public String getSold_date() {
        return this.sold_date;
    }

    public String getBuyer() {
        return this.buyer;
    }

    public String getBannedPokemon() {
        return this.bannedPokemon;
    }

    public String getRelistExpiredButtonLabel() {
        return this.relistExpiredButtonLabel;
    }

    public String getItemTitle() {
        return this.itemTitle;
    }

    public String getExpiredListingsTitle() {
        return this.expiredListingsTitle;
    }

    public String getPokemonTitle() {
        return this.pokemonTitle;
    }

    public String getFilteredListingsTitle() {
        return this.filteredListingsTitle;
    }

    public String getHistoryTitle() {
        return this.historyTitle;
    }

    public String getItemListingsTitle() {
        return this.itemListingsTitle;
    }

    public String getManageTitle() {
        return this.manageTitle;
    }

    public String getPokemonListingsTitle() {
        return this.pokemonListingsTitle;
    }

    public String getOnlyOnePokemonInParty() {
        return this.onlyOnePokemonInParty;
    }

    public String getExpiredListingButtonLabel() {
        return this.expiredListingButtonLabel;
    }

    public String getPokemonBall() {
        return this.pokemonBall;
    }

    public void init() {
        CompletableFuture<Boolean> futureRead = this.read();
        if (!futureRead.join().booleanValue()) {
            Gts.LOGGER.info("No lang.json file found for GTS. Attempting to generate one.");
            CompletableFuture<Boolean> futureWrite = this.write();
            if (!futureWrite.join().booleanValue()) {
                Gts.LOGGER.fatal("Could not write lang.json for GTS.");
            }
            return;
        }
        Gts.LOGGER.info("GTS lang file read successfully.");
    }

    private CompletableFuture<Boolean> write() {
        Gson gson = Utils.newGson();
        String data = gson.toJson((Object)this);
        return Utils.writeFileAsync("/config/gts/", "lang.json", data);
    }

    private CompletableFuture<Boolean> read() {
        return Utils.readFileAsync("/config/gts/", "lang.json", el -> {
            Gson gson = Utils.newGson();
            Versioned versioned = (Versioned)gson.fromJson(el, Versioned.class);
            Lang lang = (Lang)gson.fromJson(el, Lang.class);
            this.title = lang.getTitle();
            this.itemTitle = lang.getItemTitle();
            this.expiredListingsTitle = lang.getExpiredListingsTitle();
            this.pokemonTitle = lang.getPokemonTitle();
            this.filteredListingsTitle = lang.getFilteredListingsTitle();
            this.historyTitle = lang.getHistoryTitle();
            this.itemListingsTitle = lang.getItemListingsTitle();
            this.manageTitle = lang.getManageTitle();
            this.pokemonListingsTitle = lang.getPokemonListingsTitle();
            this.purchaseMessageBuyer = lang.getPurchaseMessageBuyer();
            this.cancelListing = lang.getCancelListing();
            this.relistExpiredButtonLabel = lang.getRelistExpiredButtonLabel();
            this.returnListingSuccess = lang.getReturnListingSuccess();
            this.returnListingFail = lang.getReturnListingFail();
            this.maximumListings = lang.getMaximumListings();
            this.minimumListingPrice = lang.getMinimumListingPrice();
            this.maximumListingPrice = lang.getMaximumListingPrice();
            this.listingSuccess = lang.getListingSuccess();
            this.listingFail = lang.getListingFail();
            this.noPokemonInSlot = lang.getNoPokemonInSlot();
            this.noItemInHand = lang.getNoItemInHand();
            this.bannedItem = lang.getBannedItem();
            this.bannedPokemon = lang.getBannedPokemon();
            this.insufficientItems = lang.getInsufficientItems();
            this.itemIdNotFound = lang.getItemIdNotFound();
            this.zeroItemAmount = lang.getZeroItemAmount();
            this.reloadMessage = lang.getReloadMessage();
            this.insufficientFunds = lang.getInsufficientFunds();
            this.listingBought = lang.getListingBought();
            this.newListingBroadcast = lang.getNewListingBroadcast();
            this.seller = lang.getSeller();
            this.price = lang.getPrice();
            this.remainingTime = lang.getRemainingTime();
            this.confirmPurchaseButtonLabel = lang.getConfirmPurchaseButtonLabel();
            this.cancelPurchaseButtonLabel = lang.getCancelPurchaseButtonLabel();
            this.removeListingButtonLabel = lang.getRemoveListingButtonLabel();
            this.itemListingsButtonLabel = lang.getItemListingsButtonLabel();
            this.pokemonListingsButtonLabel = lang.getPokemonListingsButtonLabel();
            this.manageListingsButtonLabel = lang.getManageListingsButtonLabel();
            this.nextPageButtonLabel = lang.getNextPageButtonLabel();
            this.previousPageButtonLabel = lang.getPreviousPageButtonLabel();
            this.sortByPriceButtonLabel = lang.getSortByPriceButtonLabel();
            this.sortByNewestButtonLabel = lang.getSortByNewestButtonLabel();
            this.sortByPokemonButtonLabel = lang.getSortByPokemonButtonLabel();
            this.sortByNameButtonLabel = lang.getSortByNameButtonLabel();
            this.receiveListingButtonLabel = lang.getReceiveListingButtonLabel();
            this.sold_date = lang.getSold_date();
            this.buyer = lang.getBuyer();
            this.insufficientInventorySpace = lang.getInsufficientInventorySpace();
            this.onlyOnePokemonInParty = lang.getOnlyOnePokemonInParty();
            this.itemListingsButtonItem = CodecUtils.encodeItem(lang.getItemListingsButtonItem());
            this.pokemonListingsButtonItem = CodecUtils.encodeItem(lang.getPokemonListingsButtonItem());
            this.manageListingsButtonItem = CodecUtils.encodeItem(lang.getManageListingsButtonItem());
            this.nextPageButtonItems = CodecUtils.encodeItem(lang.getNextPageButtonItems());
            this.previousPageButtonItems = CodecUtils.encodeItem(lang.getPreviousPageButtonItems());
            this.fillerItem = CodecUtils.encodeItem(lang.getFillerItem());
            this.purchaseButtonItem = CodecUtils.encodeItem(lang.getPurchaseButtonItem());
            this.cancelButtonItem = CodecUtils.encodeItem(lang.getCancelButtonItem());
            this.sortByPriceButtonItem = CodecUtils.encodeItem(lang.getSortByPriceButtonItem());
            this.sortByNewestButtonItem = CodecUtils.encodeItem(lang.getSortByNewestButtonItem());
            this.sortByNameButtonItem = CodecUtils.encodeItem(lang.getSortByNameButtonItem());
            this.expiredListingsButtonItem = CodecUtils.encodeItem(lang.getExpiredListingsButtonItem());
            this.removeListingButtonItem = CodecUtils.encodeItem(lang.getRemoveListingButtonItem());
            this.relistExpiredButtonItem = CodecUtils.encodeItem(lang.getRelistExpiredButtonItem());
            if (!versioned.getVersion().equals("2.6")) {
                LangOld oldLang = (LangOld)gson.fromJson(el, LangOld.class);
                this.write();
                this.read();
            } else {
                this.expiredListingButtonLabel = lang.getExpiredListingButtonLabel();
                this.pokemonBall = lang.getPokemonBall();
            }
        });
    }
}

